/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.CharacterQueue;
import acm.io.IOConsole;
import acm.program.Program;
import acm.program.ProgramMenuBar;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class ConsoleModel
implements KeyListener,
FocusListener {
    public static final int OUTPUT_STYLE = 0;
    public static final int INPUT_STYLE = 1;
    public static final int ERROR_STYLE = 2;
    private BufferedReader inputScript;
    private CharacterQueue buffer;
    private SimpleAttributeSet outputAttributes;
    private SimpleAttributeSet inputAttributes;
    private SimpleAttributeSet errorAttributes;
    private JScrollPane scrollPane = new JScrollPane(22, 32);
    private JTextPane textPane = new JTextPane();
    private Document document;
    private String lineSeparator;
    private int base;
    private boolean hasFocus;
    private IOConsole console;
    private Object inputLock;
    private Object outputLock;

    public ConsoleModel() {
        this.textPane.addKeyListener(this);
        this.textPane.addFocusListener(this);
        this.scrollPane.setViewportView(this.textPane);
        this.document = this.textPane.getDocument();
        this.lineSeparator = System.getProperty("line.separator");
        this.outputAttributes = new SimpleAttributeSet();
        this.inputAttributes = new SimpleAttributeSet();
        this.errorAttributes = new SimpleAttributeSet();
        this.buffer = new CharacterQueue();
        this.inputLock = new Object();
        this.outputLock = new Object();
        this.base = 0;
    }

    public void setConsole(IOConsole iOConsole) {
        this.console = iOConsole;
    }

    public IOConsole getConsole() {
        return this.console;
    }

    public void print(String string, int n) {
        Object object = this.outputLock;
        synchronized (object) {
            this.insert(string, this.base, n);
            this.base += string.length();
            this.setCaretPosition(this.base);
        }
    }

    public String readLine() {
        Object object = this.inputLock;
        synchronized (object) {
            char c;
            this.base = this.getLength();
            if (this.inputScript != null) {
                String string = null;
                try {
                    string = this.inputScript.readLine();
                }
                catch (IOException iOException) {
                    throw new ErrorException(iOException);
                }
                if (string != null) {
                    this.insert(string, this.base, 1);
                    this.insert("\n", this.base + string.length(), 0);
                    this.base += string.length() + 1;
                    String string2 = string;
                    Object var3_8 = null;
                    return string2;
                }
                try {
                    this.inputScript.close();
                }
                catch (IOException iOException) {}
                this.inputScript = null;
            }
            this.setCaretPosition(this.base);
            while ((c = this.buffer.dequeue()) != '\n' && c != '\r') {
                if (this.getCaretPosition() < this.base) {
                    this.setCaretPosition(this.getLength());
                }
                int n = this.getSelectionStart();
                switch (c) {
                    case '\b': 
                    case '\u007f': {
                        if (n == this.getSelectionEnd()) {
                            if (n <= this.base) break;
                            this.delete(n - 1, n);
                            --n;
                            break;
                        }
                        n = this.deleteSelection();
                        break;
                    }
                    case '\u0001': {
                        this.selectAll();
                        n = -1;
                        break;
                    }
                    case '\u0002': {
                        n = Math.max(this.getSelectionStart() - 1, this.base);
                        break;
                    }
                    case '\u0003': {
                        this.copy();
                        n = -1;
                        break;
                    }
                    case '\u0006': {
                        n = Math.min(this.getSelectionEnd() + 1, this.getLength());
                        break;
                    }
                    case '\u0010': {
                        this.console.printConsole();
                        n = -1;
                        break;
                    }
                    case '\u0013': {
                        this.console.save();
                        n = -1;
                        break;
                    }
                    case '\u0016': {
                        this.paste();
                        n = -1;
                        break;
                    }
                    case '\u0018': {
                        this.cut();
                        n = -1;
                        break;
                    }
                    default: {
                        if (n != this.getSelectionEnd()) {
                            n = this.deleteSelection();
                        }
                        this.insert(String.valueOf(c), n, 1);
                        ++n;
                    }
                }
                if (n == -1) continue;
                this.select(n, n);
                this.setCaretPosition(n);
            }
            int n = this.getLength() - this.base;
            String string = this.getText(this.base, this.base + n);
            this.insert("\n", this.base + n, 0);
            this.base += n + 1;
            String string3 = string;
            Object var3_9 = null;
            return string3;
        }
    }

    public void setInputScript(BufferedReader bufferedReader) {
        this.inputScript = bufferedReader;
        if (this.buffer.isWaiting()) {
            try {
                String string = this.inputScript.readLine();
                this.buffer.enqueue(String.valueOf(string) + "\n");
            }
            catch (IOException iOException) {
                throw new ErrorException(iOException);
            }
        }
    }

    public BufferedReader getInputScript() {
        return this.inputScript;
    }

    public boolean isCommandEnabled(String string) {
        return this.hasFocus;
    }

    public void clear() {
        this.textPane.setText("");
    }

    public String getText() {
        return this.textPane.getText();
    }

    public String getText(int n, int n2) {
        try {
            return this.document.getText(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            throw new ErrorException(badLocationException);
        }
    }

    public int getLength() {
        return this.document.getLength();
    }

    public Component getConsolePane() {
        return this.scrollPane;
    }

    public Component getTextPane() {
        return this.textPane;
    }

    public void cut() {
        this.copy();
        this.deleteSelection();
    }

    public void copy() {
        this.textPane.copy();
    }

    public void paste() {
        if (this.textPane.getSelectionEnd() != this.document.getLength()) {
            return;
        }
        int n = this.deleteSelection();
        this.textPane.setSelectionStart(n);
        this.textPane.paste();
        this.textPane.select(this.document.getLength(), this.document.getLength());
        if (this.document instanceof DefaultStyledDocument) {
            DefaultStyledDocument defaultStyledDocument = (DefaultStyledDocument)this.document;
            defaultStyledDocument.setCharacterAttributes(n, this.textPane.getSelectionEnd() - n, this.inputAttributes, true);
        }
    }

    public void selectAll() {
        this.textPane.selectAll();
    }

    public boolean isPointSelection() {
        return this.textPane.getSelectionStart() == this.textPane.getSelectionEnd();
    }

    public void print(PrintJob printJob) {
        String string = this.getText();
        Dimension dimension = printJob.getPageDimension();
        Graphics graphics = printJob.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = dimension.height / n;
        int n3 = this.countLines(string);
        int n4 = 1 + (n3 - 1) / n2;
        int n5 = 0;
        int n6 = 1;
        while (n6 <= n4) {
            if (n6 > 1) {
                graphics = printJob.getGraphics();
            }
            int n7 = this.getLineY(string, 1 + n6 * n2);
            graphics.translate(0, -n5);
            graphics.setClip(0, n5, dimension.width, n7 - n5);
            this.textPane.paint(graphics);
            graphics.dispose();
            n5 = n7;
            ++n6;
        }
    }

    public void setInputStyle(int n) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.inputAttributes.addAttribute(StyleConstants.Bold, new Boolean((n & 1) != 0));
        this.inputAttributes.addAttribute(StyleConstants.Italic, new Boolean((n & 2) != 0));
    }

    public void setInputColor(Color color) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.inputAttributes.addAttribute(StyleConstants.Foreground, color);
    }

    public void setErrorStyle(int n) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.errorAttributes.addAttribute(StyleConstants.Bold, new Boolean((n & 1) != 0));
        this.errorAttributes.addAttribute(StyleConstants.Italic, new Boolean((n & 2) != 0));
    }

    public void setErrorColor(Color color) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.errorAttributes.addAttribute(StyleConstants.Foreground, color);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        ProgramMenuBar programMenuBar = this.findMenuBar();
        if (programMenuBar != null) {
            programMenuBar.setConsole(this.console);
            programMenuBar.update();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.buffer.enqueue(keyEvent.getKeyChar());
        keyEvent.consume();
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: {
                this.buffer.enqueue('\u0002');
                break;
            }
            case 39: {
                this.buffer.enqueue('\u0006');
                break;
            }
        }
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void requestFocus() {
        if (this.textPane != null) {
            this.textPane.requestFocus();
        }
    }

    private void insert(String string, int n, int n2) {
        try {
            SimpleAttributeSet simpleAttributeSet = this.outputAttributes;
            switch (n2) {
                case 1: {
                    simpleAttributeSet = this.inputAttributes;
                    break;
                }
                case 2: {
                    simpleAttributeSet = this.errorAttributes;
                    break;
                }
            }
            this.document.insertString(n, string, simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void delete(int n, int n2) {
        try {
            this.document.remove(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            throw new ErrorException(badLocationException);
        }
    }

    private void setCaretPosition(int n) {
        this.textPane.setCaretPosition(n);
    }

    private int getCaretPosition() {
        return this.textPane.getCaretPosition();
    }

    private void select(int n, int n2) {
        this.textPane.select(n, n2);
    }

    private int getSelectionStart() {
        return this.textPane.getSelectionStart();
    }

    private int getSelectionEnd() {
        return this.textPane.getSelectionEnd();
    }

    private int deleteSelection() {
        int n = Math.max(this.base, this.getSelectionStart());
        int n2 = this.getSelectionEnd();
        if (n2 <= this.base) {
            return this.getLength();
        }
        this.delete(n, n2);
        return n;
    }

    private int countLines(String string) {
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(this.lineSeparator, n2 + 1)) != -1) {
            ++n;
        }
        if (!string.endsWith(this.lineSeparator)) {
            ++n;
        }
        return n;
    }

    private int getLineY(String string, int n) {
        if (string.length() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            int n3 = 1;
            while (n3 < n) {
                int n4 = string.indexOf(this.lineSeparator, n2);
                if (n4 == -1) {
                    Rectangle rectangle = this.textPane.modelToView(n2);
                    return rectangle.y + rectangle.height;
                }
                n2 = n4 + this.lineSeparator.length();
                ++n3;
            }
            return this.textPane.modelToView((int)n2).y;
        }
        catch (Exception exception) {
            throw new ErrorException("Internal error: " + exception);
        }
    }

    private ProgramMenuBar findMenuBar() {
        Container container = this.console;
        while (container != null) {
            if (container instanceof Program) {
                return ((Program)container).getMenuBar();
            }
            if (container instanceof JFrame) {
                JMenuBar jMenuBar = ((JFrame)container).getJMenuBar();
                return jMenuBar instanceof ProgramMenuBar ? (ProgramMenuBar)jMenuBar : null;
            }
            container = container.getParent();
        }
        return null;
    }
}

